// Add the DOM constants to the body if they do not already exist
var DOM_CONSTANT_LIST = ["ELEMENT_NODE", "ATTRIBUTE_NODE",
						"TEXT_NODE", "CDATA_SECTION_NODE", "ENTITY_REFERENCE_NODE",
						"ENTITY_NODE", "PROCESSING_INSTRUCTION_NODE", "COMMENT_NODE",
						"DOCUMENT_NODE", "DOCUMENT_TYPE_NODE", "DOCUMENT_FRAGMENT_NODE",
						"NOTATION_NODE"];
if (!document.ELEMENT_NODE)
{
	for (var i = 0; i < DOM_CONSTANT_LIST.length; i++)
	{
		document[DOM_CONSTANT_LIST[i]] = i + 1;
	}
}

/**
 * A simple object that provides a standard set of Ajax methods.
 *
 * @author <a href="mailto:james@jrc313.com">James Corbett</a>
 */
var Xml =
{

	_createRequestObject: function()
	{
		var xmlRequest = null;
		/*@cc_on @*/
		/*@if (@_jscript_version >= 5)
		try
		{
			xmlRequest = new ActiveXObject("Msxml2.XMLHTTP");
		}
		catch (e)
		{
			try 
			{
				xmlRequest = new ActiveXObject("Microsoft.XMLHTTP");
			}
			catch (E)
			{
				xmlRequest = null;
			}
		}
		@end @*/
		if (!xmlRequest && typeof(XMLHttpRequest) != "undefined")
		{
			xmlRequest = new XMLHttpRequest();
		}
	
		if (!xmlRequest)
		{
			xmlRequest = null;
		}
		
		return xmlRequest;
	},

	isSupported: function()
	{
		if (this.createRequestObject)
		{
			return true;
		}
		else
		{
			return false;
		}
	},

	makeRequest: function(url, postData, callbackMethod, callbackObject)
	{
	
		var xmlRequest = this._createRequestObject();
		
		if (!xmlRequest)
		{
			return false;
		}
		
		xmlRequest.onreadystatechange = function()
		{
			if (xmlRequest.readyState == 4)
			{
				if (callbackObject)
				{
					callbackObject[callbackMethod](xmlRequest);
				}
				else
				{
					callbackMethod(xmlRequest);
				}
			}
		}
		
		if (xmlRequest.overrideMimeType)
		{
			xmlRequest.overrideMimeType("text/xml");
		}
		
		var requestMethod = postData ? "POST" : "GET";
		xmlRequest.open(requestMethod, url);
		
		xmlRequest.send(postData);
		
		return true;
	},
	
	findChild: function(element, nodeName)
	{
		var child;
		for (child = element.firstChild; child != null; child = child.nextSibling)
		{
			if (child.nodeName == nodeName)
				return child;
		}
		
		return null;
	},
	
	removeAllChildren: function(node)
	{
		while (node.childNodes.length > 0)
		{
			node.removeChild(node.childNodes[0]);
		}
	}
}